/**
* \file: BaiduCoreCallbackDealer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_BAIDUCORECALLBACKDEALER_H
#define BDCL_BAIDUCORECALLBACKDEALER_H

#include <bdcl/CCarLifeLib.h>
#include "AditBackendCallbacks.h"

namespace adit { namespace bdcl {

class IAditAudioSinkCallbacks;
class IAditAudioSourceCallbacks;
class IAditVideoSinkCallbacks;

// todo get the threads also here, maybe even divide the class to dispatch to different endpoints
class CoreCallbackDealer
{
public:
    CoreCallbackDealer();
    ~CoreCallbackDealer();

    void registerVideoSinkCallbacks(IAditVideoSinkCallbacks* inCallbacks);
    void registerVideoSinkBackendCallbacks(IVideoSinkBackendCallbacks* inCallbacks);

    void registerMediaAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks);
    void registerMediaAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks);

    void registerNaviTtsAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks);
    void registerNaviTtsAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks);

    void registerVrTtsAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks);
    void registerVrTtsAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks);

    void registerVrCaptureAudioCallbacks(IAditAudioSourceCallbacks* inCallbacks);

private:
    /* Media audio sink callbacks initiated by Baidu core - consumed by MC */
    static void mediaInit(S_AUDIO_INIT_PARAMETER *initParam);
    static void mediaStop();
    static void mediaPause();
    static void mediaResume();
    /* Media audio sink callbacks initiated by Baidu core - consumed by ADIT */
    static void mediaNormalData(u8 *data, u32 len);

    /* Navigation text-to-speech audio sink callbacks initiated by Baidu core - consumed by MC */
    static void ttsInit(S_AUDIO_INIT_PARAMETER *initParam);
    static void ttsStop();
    /* Navigation text-to-speech audio sink callbacks initiated by Baidu core - consumed by ADIT */
    static void ttsNormalData(u8 *data, u32 len);

    /* Voice recognition text-to-speech audio sink callbacks initiated by Baidu core - consumed by MC */
    static void vrInit(S_AUDIO_INIT_PARAMETER *initParam);
    static void vrStop();
    static void vrInterrupt();
    /* Voice recognition text-to-speech audio sink callbacks initiated by Baidu core - consumed by ADIT */
    static void vrNormalData(u8 *data, u32 len);

    /* Voice recognition capture audio source callbacks initiated by Baidu core - consumed by MC */
    static void cmdMicRecordWakeupStart();
    static void cmdMicRecordEnd();
    static void cmdMicRecordRecogStart();

    /* Video sink callbacks initiated by Baidu core - consumer by ADIT */
    static void cmdVideoEncoderInitDone(S_VIDEO_ENCODER_INIT_DONE* videoEncoderInitDone);
    static void cmdRegisterConnectException(S_CONNECTION_EXCEPTION* inException);
    /* Video sink callbacks initiated by Baidu core - consumer by EP */
    static void videoDataReceive(u8 *data, u32 len);
    static IAditAudioSinkCallbacks* mMediaAudioCallbacks;
    static IAudioSinkBackendCallbacks* mMediaAudioBackendCallbacks;

    static IAditAudioSinkCallbacks* mNaviTtsAudioCallbacks;
    static IAudioSinkBackendCallbacks* mNaviTtsAudioBackendCallbacks;

    static IAditAudioSinkCallbacks* mVrTtsAudioCallbacks;
    static IAudioSinkBackendCallbacks* mVrTtsAudioBackendCallbacks;

    static IAditAudioSourceCallbacks* mVrCaptureAudioCallbacks;

    static IAditVideoSinkCallbacks* mVideoSinkCallbacks;
    static IVideoSinkBackendCallbacks* mVideoSinkBackendCallbacks;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_BAIDUCORECALLBACKDEALER_H */
